function EegAnalysis2(block)
% Level-2 M file S-function for applying Sobel filtering  
% (image edge detection demonstration).
%   Copyright 1990-2004 The MathWorks, Inc.
%   $Revision: 1.1.6.1 $    
  
  setup(block);

%endfunction

function setup(block)
  
  %% Register dialog parameter: edge direction 
  block.NumDialogPrms = 5;
  block.DialogPrmsTunable = {'Tunable','Tunable','Tunable','Tunable','Tunable'};
 
  %% Register ports
  block.NumInputPorts  = 1;
  block.NumOutputPorts = 5;
  
  %% Setup port properties
  block.SetPreCompInpPortInfoToDynamic;
  %block.SetPreCompOutPortInfoToDynamic;

  block.InputPort(1).DatatypeID   = 0;
  block.InputPort(1).Complexity   = 'Real';
  block.InputPort(1).SamplingMode = 'Sample';
  blocl.InputPort(1).Overwritable = false; % No in-place operation
  
  block.OutputPort(1).DatatypeID   = 0;
  block.OutputPort(1).Complexity   = 'Real';
  block.OutputPort(1).SamplingMode = 'Sample';
  block.OutputPort(1).Dimensions   = 1;
  
  block.OutputPort(2).DatatypeID   = 0;
  block.OutputPort(2).Complexity   = 'Real';
  block.OutputPort(2).SamplingMode = 'Sample';
  block.OutputPort(2).Dimensions   = 1;
  
  block.OutputPort(3).DatatypeID   = 0;
  block.OutputPort(3).Complexity   = 'Real';
  block.OutputPort(3).SamplingMode = 'Sample';
  block.OutputPort(3).Dimensions   = 1;
  
  block.OutputPort(4).DatatypeID   = 0;
  block.OutputPort(4).Complexity   = 'Real';
  block.OutputPort(4).SamplingMode = 'Sample';
  block.OutputPort(4).Dimensions   = 1;
  
  block.OutputPort(5).DatatypeID   = 0;
  block.OutputPort(5).Complexity   = 'Real';
  block.OutputPort(5).SamplingMode = 'Sample';
  block.OutputPort(5).Dimensions   = 1;
%   block.OutputPort(3).DatatypeID   = 0;
%   block.OutputPort(3).Complexity   = 'Real';
%   block.OutputPort(3).SamplingMode = 'Sample';
%   block.OutputPort(3).Dimensions   = 1;
  
  %% Register block methods (through MATLAB function handles)
  block.RegBlockMethod('Outputs', @Output);
  block.RegBlockMethod('WriteRTW',@WriteRTW);

  %% Block runs on TLC in accelerator mode.
  block.SetAccelRunOnTLC(true);





function Output(block)
  %pat = size(block.InputPort(1).Data)
  %%dir = block.DialogPrm(1).Data;
 %ratara = size(BancFiltres(block.InputPort(1).Data))
% block.DialogPrm(1).Data
%  block.OutputPort(2).Data
 


%block.OutputPort(1).Data = BancFiltres(block.InputPort(1).Data);
[block.OutputPort(1).Data, block.OutputPort(2).Data, block.OutputPort(3).Data]= tempsreel_CSSD(block.InputPort(1).Data,block.DialogPrm(1).Data,block.DialogPrm(2).Data,block.DialogPrm(3).Data,block.DialogPrm(4).Data,block.DialogPrm(5).Data);
block.OutputPort(4).Data =block.DialogPrm(1).Data;
block.OutputPort(5).Data =block.DialogPrm(2).Data;
    %block.OutputPort(2).Data = block.DialogPrm(1).Data
 % block.OutputPort(3).Data = block.DialogPrm(2).Data
%endfunction
%block.DialogPrm(1).Data
%block.DialogPrm(2).Data
% function WriteRTW(block)
%   
%    block.WriteRTWParam('matrix', 'M',    [1 2; 3 4]);
%    block.WriteRTWParam('string', 'Mode', 'Auto');
   

% function moy = Moy(mat)
% moy = mean(mat);
% moy = mean(moy)

function  [y1,y2,y3] = tempsreel_CSSD(signal,freq_lo,freq_hi,SPg,SFg,net)

%signal =signal';
filtAn = [0.0013 -0.0002 -0.0106 0.0027 0.0347 -0.0192 -0.0367 0.2577 0.5496 0.3404 -0.0433 -0.1013 0.0054 0.0224 -0.0004 -0.0024];

phi0 = filtAn;


%%%%%%%%%%%%%%%%%   -----Ondelettes-------   %%%%%%%%%%%%%%%%%
j = 0;    
h0 = reverse(phi0);                   %  cette ondelette nous donne le signal : eeg32
h1 = reverse(mirror(phi0));           % ... : residu
j = 1;   
H0 = upSample(h0);                  
H1 = upSample(h1);                 
phi10 = waveletLo(phi0,H0);    % eeg16
phi11 = waveletHi(phi0,H1);    % beta = [16-32]Hz
j = 2;
H0 = upSample(H0);
H1 = upSample(H1);
phi20 = waveletLo(phi10,H0);   % eeg8L
phi21 = waveletHi(phi10,H1);   % eeg8H
phi22 = waveletHi(phi11,H1);   % [16-24]Hz
phi23 = waveletLo(phi11,H0);   % [24-32]Hz
j = 3;
H0 = upSample(H0);
H1 = upSample(H1);
phi30 = waveletLo(phi20,H0);   % eeg4
phi31 = waveletHi(phi20,H1);   % theta
phi32 = waveletHi(phi21,H1);   % alpha   = [8-12]Hz
phi33 = waveletLo(phi21,H0);   % sigma   = [12-16]Hz
phi34 = waveletLo(phi22,H0);   % [16-20]Hz
phi35 = waveletHi(phi22,H1);   % [20-24]Hz
phi36 = waveletHi(phi23,H1);   % [24-28]Hz
phi37 = waveletLo(phi23,H0);   % [28-32]Hz
j = 4;
H0 = upSample(H0);
H1 = upSample(H1);
phi40 = waveletLo(phi30,H0);  % eeg2
phi41 = waveletHi(phi30,H1);  % delta 4
phi42 = waveletHi(phi34,H1);   % [16-18]Hz
phi43 = waveletLo(phi34,H0);   % beta1  [18-20]Hz
phi44 = waveletLo(phi35,H0);   % beta3  [22-24]Hz
phi45 = waveletHi(phi35,H1);   % beta2  [20-22]Hz

phi46 = waveletLo(phi32,H0); %alpha [8-10]
phi47 = waveletHi(phi32,H1);%alpha [10-12]

j =5;
H0 = upSample(H0);
H1 = upSample(H1);

phi51 = waveletLo(phi47,H0);%alpha [10-11]
phi52 = waveletHi(phi47,H1);%alpha [11-12]

%%%%%%%%%%%%%%%%

[canaux,ech] = size(signal);

for j=1:canaux
    s = resample(signal(j,:),128,64);
    xx = conv(reverse(phi32),s);
    X(:,j) = redconv(phi32,xx);
    if (j==17)|(j==18)|(j==10)|(j==9)|(j==13)|(j==15)
        eeg32 = redconv(conv(s,reverse(h0)),h0);
        eeg32_var = var(eeg32);
        Ik = length(eeg32);
        q=15;
        for i=1:(Ik-q)
            NWPalpha(i,j) = var(X(i:i+q,j))/eeg32_var;
        end
    end
end
y1=median(NWPalpha(:,17)+NWPalpha(:,18)+NWPalpha(:,9)+NWPalpha(:,10)+NWPalpha(:,13)+NWPalpha(:,15));

if freq_lo == 8
 
    
    if freq_hi == 10
        freq = phi46;
    elseif freq_hi == 12
        freq = phi32;
    end

    
elseif freq_lo == 10
  
    
    if freq_hi == 11
        freq = phi51;
    elseif freq_hi == 12
        freq = phi47;
    end

    
%elseif freq_lo == 12
 %   freq = phi33;


elseif freq_lo == 12
    freq = phi33;


elseif freq_lo == 16
    if freq_hi == 20
        freq = phi34;
    elseif freq_hi == 18
        freq = phi42;
    end
    

elseif freq_lo == 20
    freq = phi35;

end



for j=1:canaux
    s2 = resample(signal(:,j),128,64);
    xx2 = conv(s,reverse(freq));
    X2(:,j) = redconv(xx2,freq);
    if (j==17)|(j==18)|(j==10)|(j==9)|(j==13)|(j==15)
        eeg32b = redconv(conv(s2,reverse(h0)),h0);
        eeg32_varb = var(eeg32b);
        Ikb = length(eeg32b);
        q=15;
        for i=1:(Ikb-q)
            NWPalpha2(i,j) = var(X2(i:i+q,j))/eeg32_varb;
        end
    end
end
y2=median((NWPalpha2(:,13)-NWPalpha2(:,15))./(NWPalpha2(:,13)+NWPalpha2(:,15)));




%%%%%%%%%CSSD%%%%%%%%%%%
Z=X(:,1:18);
[ech,canaux] = size(Z);
% load SPg;
% load SFg;
% load net;
Xcssdtest =[];
C = Z';
Xcssdtest = SPg*SFg*C;

test=Xcssdtest';
Ptest =[];
for electrode = 1:canaux
                      Ptest(j,electrode)=var(test(:,electrode,j));
%     [Pxxi, Pxxc, F] = PSD(test(:,electrode), 450, 128, 450, 0, 0.95, 'linear');
%     Puissi = mean(Pxxi(find(8 < F & F < 12)));
%     Ptest = cat(1,Ptest,Puissi);
%     Ptesting(:,electrode)=Ptest;
%     Ptest = [];
end
% Py = Ptesting;
Py = Ptest;
[Yak, Yak1] = svmfwd(net, Py);
y3=Yak1;



function fout = upSample(fin)
o = zeros(1,1);
n = length(fin);
fout = 0;
ftemp = [fin(1);o];
fout = ftemp;
for i=2:n-1
   ftemp = [fin(i);o];
   fout = [fout;ftemp];
end;
fout = [fout;fin(n)];
fout = fout';
   

function y = waveletHi(x,qmf)
y = conv(reverse((mirror(qmf))),x);


function y = waveletLo(x,qmf)
y = conv(qmf,x);


function y = mirror(x)
y = -( (-1).^(1:length(x)) ).*x;


function r = reverse(x)
r = x(length(x):-1:1);

function y = redconv(s,f)
i = round(length(f)/2);
y = s((i):(length(s)-(length(f)-i)));  

function [Y, Y1] = svmfwd(net, X)
% SVMFWD - Forward propagation through Support Vector Machine classifier
% 
%   Y = SVMFWD(NET, X)
%   For a data structure NET, the matrix of vectors X is input into the
%   Support Vector Machine described by NET and the matrix of outputs Y
%   is computed. NET must have non-empty fields NET.sv, NET.svcoeff and
%   NET.bias, these fields are set during training by SVMTRAIN.
%   X must contain one input vector per row. Y is a column vector with
%   one entry for each input vector in X. Y(i) is the SVM output for
%   input vector X(i,:), it is
%     +1, if X(i,:) is classified as belonging to class 1
%     -1, if X(i,:) is classified as belonging to class -1
%   [Y, Y1] = SVMFWD(NET, X) also gives the column vector Y1 containing
%   the SVM output before computing the sign. Y1(i) is equivalent to the
%   distance of point X(i,:) from the separating hyperplane.
%
%   See also
%   SVM, SVMTRAIN, SVMKERNEL
%

% 
% Copyright (c) Anton Schwaighofer (2001)
% $Revision: 1.2 $ $Date: 2002/01/07 19:53:06 $
% mailto:anton.schwaighofer@gmx.net
% 
% This program is released unter the GNU General Public License.
% 

% Check arguments for consistency
errstring = consist(net, 'svm', X);
if ~isempty(errstring);
  error(errstring);
end
[N d] = size(X);
if strcmp(net.kernel, 'linear'),
  if ~isfield(net, 'normalw') | ~all(size(net.normalw)==[1 d]),
    error('Structure NET does not contain a valid field ''normalw''');
  end
else
  if ~isfield(net, 'sv') | ((size(net.sv, 2)~=d) & ~isempty(net.sv)),
    error('Structure NET does not contain a valid field ''sv''');
  end
  nbSV = size(net.sv, 1);
  if nbSV~=size(net.svcoeff, 1),
    error('Structure NET does not contain a valid field ''svcoeff''');
  end
  if ~isfield(net, 'bias') | ~all(size(net.bias)==[1 1]),
    error('Structure NET does not contain a valid field ''bias''');
  end
end

if strcmp(net.kernel, 'linear'),
  Y1 = X*(net.normalw');
else
  chsize = net.chunksize;
  Y1 = zeros(N, 1);
  chunks1 = ceil(N/chsize);
  chunks2 = ceil(nbSV/chsize);
  for ch1 = 1:chunks1,
    ind1 = (1+(ch1-1)*chsize):min(N, ch1*chsize);
    for ch2 = 1:chunks2,
      ind2 = (1+(ch2-1)*chsize):min(nbSV, ch2*chsize);
      K12 = svmkernel(net, X(ind1, :), net.sv(ind2, :));
      Y1(ind1) = Y1(ind1)+K12*net.svcoeff(ind2);
    end
  end
end
Y1 = Y1+net.bias;
Y = sign(Y1);
Y(Y==0) = 1;    

